/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.client.integration.jei;

import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.tags.ITag;
import tcintegrations.data.tcon.SmelteryCompat;
import tcintegrations.util.ResourceLocationHelper;
import tcintegrations.util.TagHelper;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocationHelper.resource("jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IIngredientManager manager = jeiRuntime.getIngredientManager();
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            ITag<Item> ingot = TagHelper.getTag(ResourceLocationHelper.location("forge", "ingots/" + compat.getName()));
            if (!ingot.isEmpty()) continue;
            try {
                JEIPlugin.removeFluid(manager, compat.getFluid().get(), compat.getBucket());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private static void removeFluid(IIngredientManager manager, Fluid fluid, Item bucket) {
        manager.removeIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, Collections.singleton(new FluidStack(fluid, 1000)));
        manager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)bucket)));
    }
}

